//
//  Colors.m
//  HelloWorld
//
//  Created by Erica Sadun on 7/18/11.
//  Copyright 2011 Up To No Good, Inc. All rights reserved.
//

#import "Colors.h"

void rgbtohsb(CGFloat r, CGFloat g, CGFloat b, CGFloat *pH, CGFloat *pS, CGFloat *pV)
{
	CGFloat h,s,v;
	
	// Na podstawie Foleya i Van Dama.
	CGFloat max = MAX(r, MAX(g, b));
	CGFloat min = MIN(r, MIN(g, b));
	
	// Jasność.
	v = max;
	
	// Nasycenie.
	s = (max != 0.0f) ? ((max - min) / max) : 0.0f;
	
	if (s == 0.0f) {
		// Brak nasycenia, więc trzeba usunąć definicję barwy.
		h = 0.0f;
	} else {
		// Określenie barwy na podstawie odległości od…
		CGFloat rc = (max - r) / (max - min);		// czerwonego.
		CGFloat gc = (max - g) / (max - min);		// zielonego.
		CGFloat bc = (max - b) / (max - min);		// niebieskiego.
		
		if (r == max) h = bc - gc;					// pomiędzy kolorami żółtym i magenta.
		else if (g == max) h = 2 + rc - bc;			// pomiędzy kolorami cyjan i żółtym.
		else /* if (b == max) */ h = 4 + gc - rc;	// pomiędzy kolorami magenta i cyjan.
		
		h *= 60.0f;									// Konwersja na stopnie.
		if (h < 0.0f) h += 360.0f;					// Wartość nie może być ujemna.
	}
	
	if (pH) *pH = h;
	if (pS) *pS = s;
	if (pV) *pV = v;
}

void hsbtorgb(CGFloat h, CGFloat s, CGFloat v, CGFloat *pR, CGFloat *pG, CGFloat *pB)
{
	CGFloat r = 0.0f;
	CGFloat g = 0.0f;
	CGFloat b = 0.0f;
	
	// Na podstawie Foleya i Van Dama.
	
	if (s == 0.0f) {
		// Kolor achromatyczny: brak nasycenia.
		r = g = b = v;
	} else {
		// Kolor chromatyczny: nasycenie.
		if (h == 360.0f) h = 0.0f;
		h /= 60.0f;										// h jest teraz w [0, 6)
		
		int i = floorf(h);								// największa liczba całkowita <= h
		CGFloat f = h - i;								// część ułamkowa h
		CGFloat p = v * (1 - s);
		CGFloat q = v * (1 - (s * f));
		CGFloat t = v * (1 - (s * (1 - f)));
		
		switch (i) {
			case 0:	r = v; g = t; b = p;	break;
			case 1:	r = q; g = v; b = p;	break;
			case 2:	r = p; g = v; b = t;	break;
			case 3:	r = p; g = q; b = v;	break;
			case 4:	r = t; g = p; b = v;	break;
			case 5:	r = v; g = p; b = q;	break;
		}
	}
	
	if (pR) *pR = r;
	if (pG) *pG = g;
	if (pB) *pB = b;
}
